/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.DataBlock;
import com.quantumdata.busmon.parser.I2CMessage;
import com.quantumdata.busmon.parser.I2CMessageType;
import com.quantumdata.busmon.parser.I2CSignal;
import com.quantumdata.busmon.parser.TypeConverter;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I2CDataBlock
extends DataBlock {
    protected long startstamp;
    protected long stopstamp;
    protected long timestamp;
    protected static long lastStartstamp = 0L;
    protected static long lastStopstamp = 0L;
    protected int period;
    protected int eventType;
    protected int sourceID;
    protected I2CMessage message;
    protected Vector<I2CSignal> rawMessage;
    protected boolean isFaulty;
    protected String whyFaulty;
    protected static I2CDataBlock lastBlock = null;

    public I2CDataBlock(Integer[] integerArray) {
        int n;
        this.eventType = integerArray[7];
        this.sourceID = integerArray[8];
        this.timestamp = TypeConverter.composeLong(integerArray, 9);
        this.startstamp = 0L;
        this.stopstamp = 0L;
        this.period = 65535;
        this.message = null;
        this.rawMessage = I2CDataBlock.getWorkingMessage();
        this.isFaulty = false;
        this.whyFaulty = "";
        long l = TypeConverter.composeLong(integerArray, 13);
        boolean bl = false;
        switch (this.eventType) {
            case 1: {
                boolean bl2;
                int n2;
                if (lastBlock != null && I2CDataBlock.lastBlock.eventType != 2) {
                    I2CDataBlock.lastBlock.message = new I2CMessage(I2CDataBlock.lastBlock.rawMessage);
                    if (I2CDataBlock.lastBlock.message.isError()) {
                        this.isFaulty = true;
                    }
                    for (n = 0; n < I2CDataBlock.lastBlock.rawMessage.size(); ++n) {
                        if (I2CDataBlock.lastBlock.rawMessage.get(n).getPeriod() >= I2CDataBlock.lastBlock.period) continue;
                        I2CDataBlock.lastBlock.period = I2CDataBlock.lastBlock.rawMessage.get(n).getPeriod();
                    }
                }
                this.rawMessage.clear();
                this.rawMessage.add(new I2CSignal(1, 0));
                this.startstamp = this.timestamp;
                lastStartstamp = this.timestamp;
                this.stopstamp = lastStopstamp;
                lastStopstamp = this.timestamp;
                if (l > 0L) {
                    n2 = 0;
                    while ((long)n2 < l) {
                        boolean bl3 = bl2 = integerArray[n2 + 18] == 1;
                        if (!bl2) {
                            bl = true;
                        }
                        this.rawMessage.add(new I2CSignal(2, integerArray[n2 + 17], bl2, TypeConverter.composeInt(integerArray, n2 + 19)));
                        n2 += 4;
                    }
                }
                lastBlock = this;
                break;
            }
            case 2: {
                if (lastBlock != null) {
                    I2CDataBlock.lastBlock.rawMessage = null;
                    I2CDataBlock.lastBlock.message = null;
                }
                this.rawMessage.add(new I2CSignal(3, 0));
                this.message = new I2CMessage(this.rawMessage);
                if (this.message.isError()) {
                    this.isFaulty = true;
                }
                this.stopstamp = this.timestamp;
                lastStopstamp = this.timestamp;
                for (n = 0; n < this.rawMessage.size(); ++n) {
                    if (this.rawMessage.get(n).getPeriod() >= this.period) continue;
                    this.period = this.rawMessage.get(n).getPeriod();
                }
                lastBlock = null;
                I2CMessage.processingI2CRead = false;
                break;
            }
            case 3: {
                boolean bl2;
                int n2;
                if (lastBlock != null) {
                    I2CDataBlock.lastBlock.rawMessage = null;
                    I2CDataBlock.lastBlock.message = null;
                }
                if (l > 0L) {
                    n2 = 0;
                    while ((long)n2 < l) {
                        boolean bl4 = bl2 = integerArray[n2 + 18] == 1;
                        if (!bl2) {
                            bl = true;
                        }
                        this.rawMessage.add(new I2CSignal(2, integerArray[n2 + 17], bl2, TypeConverter.composeInt(integerArray, n2 + 19)));
                        n2 += 4;
                    }
                }
                lastBlock = this;
                break;
            }
            default: {
                this.isFaulty = true;
                this.whyFaulty = this.whyFaulty + String.format("An I2C event from the analyzer had the unknown data type 0x%04X.\n", this.eventType);
                lastBlock = null;
            }
        }
        this.startstamp = lastStartstamp;
        if (bl) {
            this.message = new I2CMessage(this.rawMessage);
            if (this.message.isError()) {
                this.isFaulty = true;
            }
            this.stopstamp = this.timestamp;
            lastStopstamp = this.timestamp;
            for (n = 0; n < this.rawMessage.size(); ++n) {
                if (this.rawMessage.get(n).getPeriod() >= this.period) continue;
                this.period = this.rawMessage.get(n).getPeriod();
            }
            lastBlock = this;
        }
    }

    @Override
    public boolean isError() {
        boolean bl = this.isFaulty;
        if (this.message != null) {
            bl |= this.message.isError();
        }
        return bl;
    }

    public String whyError() {
        String string = this.whyFaulty;
        if (this.message != null) {
            string = string + this.message.whyError();
        }
        return string;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public long getStartTimestamp() {
        return this.startstamp;
    }

    public long getStopTimestamp() {
        return this.stopstamp;
    }

    public int getPeriod() {
        return this.period;
    }

    public I2CMessageType getMessageType() {
        if (this.message != null) {
            return this.message.getMessageType();
        }
        return I2CMessageType.UNKNOWN;
    }

    @Override
    public String getType() {
        if (this.message != null) {
            return this.message.getType();
        }
        return "Other I2C";
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.message != null) {
            stringBuffer.append(this.message.getExplanation());
        } else if (this.rawMessage != null) {
            stringBuffer.append("Incomplete Message");
        } else if (this.isFaulty) {
            stringBuffer.append("Bad I2C Message");
        } else {
            stringBuffer.append("Empty Packet");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("I2C Message Details\n");
        stringBuffer.append("-------------------\n");
        stringBuffer.append("     Time since last reset: ");
        stringBuffer.append(TypeConverter.getTimestampString(this.startstamp * 100L));
        stringBuffer.append("\n");
        stringBuffer.append("        Total message time: ");
        stringBuffer.append(TypeConverter.getTimeString(this.timestamp - this.startstamp));
        stringBuffer.append("\n");
        stringBuffer.append("Maximum I2C transfer speed: ");
        stringBuffer.append(TypeConverter.getSpeedString(this.period));
        stringBuffer.append(" kbps");
        stringBuffer.append("\n");
        if (this.message != null) {
            stringBuffer.append(this.message.getDetails());
        } else if (this.rawMessage != null) {
            stringBuffer.append("This I2C message is incomplete, and therefore could not be fully parsed.");
        } else {
            stringBuffer.append("This I2C message contains no data.");
        }
        stringBuffer.append("\n");
        if (this.isFaulty) {
            stringBuffer.append("\n");
            stringBuffer.append(this.whyFaulty);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public Vector<I2CSignal> getRawMessage() {
        return this.rawMessage;
    }

    public I2CMessage getMessage() {
        return this.message;
    }

    @Override
    public int getSourceID() {
        return this.sourceID;
    }

    public static void resetParser() {
        lastBlock = null;
    }

    public static Vector<I2CSignal> getWorkingMessage() {
        if (lastBlock != null) {
            return new Vector<I2CSignal>(I2CDataBlock.lastBlock.rawMessage);
        }
        return new Vector<I2CSignal>();
    }

    @Override
    public String getDirection() {
        if (this.message != null) {
            return this.message.getDirection();
        }
        return "";
    }

    @Override
    public short getSource() {
        return 2;
    }

    @Override
    public String getSourceName() {
        return "I2C";
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public boolean isI2C() {
        return true;
    }

    @Override
    public boolean isCEC() {
        return false;
    }

    @Override
    public boolean isHDCP() {
        return this.getMessageType() == I2CMessageType.HDCP;
    }

    @Override
    public boolean isDDCCI() {
        return this.getMessageType() == I2CMessageType.DDCCI;
    }

    @Override
    public boolean isEDID() {
        return this.getMessageType() == I2CMessageType.EDID;
    }

    @Override
    public boolean isLT() {
        return false;
    }
}

